using System;
using System.Linq;

class PecinskiZec
{
    static void Main(string[] args)
    {
        int brojSobaZeca = int.Parse(Console.ReadLine());
        int[] vezeSoba = new int[brojSobaZeca + 1];
        bool[] statusPlatforme = Enumerable.Repeat(true, brojSobaZeca + 1).ToArray();

        for (int soba = 0; soba < brojSobaZeca - 1; soba++)
        {
            string[] unosVeza = Console.ReadLine().Split();
            int sobaU = int.Parse(unosVeza[0]);
            int sobaV = int.Parse(unosVeza[1]);
            vezeSoba[sobaV] = sobaU;
        }

        int[] nizPromena = Console.ReadLine().Split().Select(int.Parse).ToArray();

        for (int indeksSobe = 1; indeksSobe <= brojSobaZeca; indeksSobe++)
        {
            if (nizPromena[indeksSobe - 1] > 0)
            {
                statusPlatforme[nizPromena[indeksSobe - 1]] = !statusPlatforme[nizPromena[indeksSobe - 1]];
            }

            int trenutnaSobaZeca = indeksSobe;
            int snagaSkoka = indeksSobe;
            int brojSkokovaZeca = 0;

            while (trenutnaSobaZeca != 1 && snagaSkoka > 0)
            {
                int ciljanaSoba = Math.Max(1, trenutnaSobaZeca - snagaSkoka);
                while (ciljanaSoba < trenutnaSobaZeca && !statusPlatforme[ciljanaSoba])
                {
                    ciljanaSoba++;
                }

                if (trenutnaSobaZeca == ciljanaSoba)
                {
                    brojSkokovaZeca = -1;
                    break;
                }

                trenutnaSobaZeca = ciljanaSoba;
                brojSkokovaZeca++;
            }

            if (brojSkokovaZeca != -1)
            {
                Console.WriteLine(brojSkokovaZeca);
            }
        }
    }
}